/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2013 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.cq.personalization;

/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

import javax.servlet.ServletException;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.day.cq.wcm.webservicesupport.ConfigurationManagerFactory;

/**
 * Datasource for the campaigns selector in the new Target Authoring UI
 *
 * @author platon
 */
@Deprecated
public class CampaignsDataSourceServlet extends SlingSafeMethodsServlet {

    private static final String CAMPAIGNPAGE_RESOURCE_TYPE = "cq/personalization/components/campaignpage";
    private static final String CAMPAIGNS_ROOT = "/content/campaigns";
    private static final String ACTIVITY_TYPE = "campaignType";

    private ConfigurationManagerFactory configManagerFactory;

    protected void bindConfigManagerFactory(ConfigurationManagerFactory configManagerFactory) {
        //no-op
    }

    protected void unbindConfigManagerFactory(ConfigurationManagerFactory configManagerFactory)          {
        //no-op
    }

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException,
            IOException {

        ResourceResolver resolver = request.getResourceResolver();

        // descent down the campaigns path:
        CampaignsRetriever visitor = new CampaignsRetriever();
        visitor.accept(resolver.getResource(CAMPAIGNS_ROOT));

        List<Resource> resourceList = visitor.getCampaigns();

        // sort alphabetically
        final Collator c = Collator.getInstance(request.getLocale());
        Collections.sort(resourceList, new Comparator<Resource>() {
            @Override
            public int compare(Resource r1, Resource r2) {
                String t1 = r1.getValueMap().get("text", "");
                String t2 = r2.getValueMap().get("text", "");
                return c.compare(t1, t2);
            }
        });
        // add the "please select entry
        request.setAttribute(DataSource.class.getName(), new SimpleDataSource(resourceList.iterator()));
    }

    private Configuration getTargetConfiguration(InheritanceValueMap properties, ConfigurationManager cfgMgr) {
        String[] services = properties.getInherited("cq:cloudserviceconfigs", new String[]{});
        if(cfgMgr != null) {
            return cfgMgr.getConfiguration("testandtarget", services);
        }
        return null;
    }

    class CampaignsRetriever extends AbstractResourceVisitor {

        List<Resource> campaigns = new ArrayList<Resource>();

        protected void visit(final Resource resource) {
            if (CAMPAIGNPAGE_RESOURCE_TYPE.equals(resource.getResourceType())) {
                InheritanceValueMap props = new HierarchyNodeInheritanceValueMap(resource);

                ResourceResolver resolver = resource.getResourceResolver();
                ConfigurationManager cfgMgr = configManagerFactory.getConfigurationManager(resolver);
                Configuration targetConfig = getTargetConfiguration(props, cfgMgr);

                String activityTitle = props.get("jcr:title", resource.getParent().getName());
                String activityType = props.get(ACTIVITY_TYPE, "landingPage");

                String activityTypeMarker = "AEM";

                boolean isActiveProp = props.get("campaignActive", true);
                Calendar campaignEndTime = props.get("offTime", Calendar.class);
                Calendar currentTime = Calendar.getInstance();

                boolean isActive = isActiveProp
                        && (campaignEndTime == null || currentTime.before(campaignEndTime));

                // pick up the Target activities which are active (ignore inactivated ones)
                boolean useActivity = true;

                if (targetConfig != null) {
                    activityTypeMarker = "landingPage".equals(activityType) ?
                            "XT" : "A/B";

                    useActivity = isActive;
                }

                if (useActivity) {
                    final String title = activityTitle + " [" + activityTypeMarker + "]";
                    final String path = resource.getParent().getPath();
                    Map<String,Object> entry = new HashMap<String,Object>(){{
                        put("value", path);
                        put("text", title);
                    }};

                    ValueMapResource vmRes = new ValueMapResource(resolver, new ResourceMetadata(), "", new ValueMapDecorator(entry));
                    campaigns.add(vmRes);
                }
            }
        }

        public List<Resource> getCampaigns() {
            return campaigns;
        }

    }

}
