/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.personalization;

import java.util.List;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A teaser meta-data object
 */
@ProviderType
public interface Teaser {

    /**
     * Returns the repository path of the teaser
     * @return a {@link String} representing the path
     */
    String getPath();

    /**
     * Returns the source repository path of the teaser
     * @return a {@link String} representing the path
     */
    String getSourcePath();

    /**
     * Returns the name of the teaser
     * @return a {@link String} representing the name
     */
    String getName();

    /**
     * Returns the title of the teaser
     * @return a {@link String} representing the title
     */
    String getTitle();

    /**
     * Return the name of the campaign that contains this teaser
     * @return a {@link String} representing the name of the campaign
     */
    String getCampaignName();

    /**
     * Returns the path of the campaign that contains this teaser
     * @return a {@link String} representing the path to the campaign
     */
    String getCampaignPath();

    /**
     * Returns the path to the thumbnail of this teaser (the *.thumb.png selector)
     * @return a {@link String} representing the path to the thumbnail
     */
    String getThumbnailPath();

    /**
     * Returns the unique id of the teaser.
     * @return a {@link String} representing the unique id
     */
    String getId();

    /**
     * Returns a list of segments associated with this teaser
     * @return a {@link List} of {@link String} objects, or an empty list if the teaser has no segments
     */
    List<String> getSegments();

    /**
     * Returns the list of tags associated to this teaser
     * @return a {@link List} of {@link TeaserTag} objects or an empty list if the teaser has no tags
     */
    List<TeaserTag> getTags();

    /**
     * Returns the URL to the teaser
     * @return a {@link String} representing the URL
     */
    String getUrl();
}
