/*******************************************************************************
 * ADOBE CONFIDENTIAL
 *  __________________
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.personalization.offerlibrary.usebean;

import java.util.Calendar;

import javax.jcr.Node;

import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.sightly.WCMUsePojo;
import com.day.cq.commons.date.RelativeTimeFormat;
import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.wcm.api.components.Component;

/**
 * Provides data for the script at /libs/cq/personalization/touch-ui/components/offercard/offercard.html
 * 
 * @deprecated no replacement as not used anymore
 */
@Deprecated
public class OffercardPropertiesProvider extends WCMUsePojo {

    public static final Logger LOGGER = LoggerFactory.getLogger(OffercardPropertiesProvider.class);

    private Resource resource = null;

    private String type;

    @Override
    public void activate() throws Exception {
        Resource currentResource = (Resource)getRequest().getAttribute(Resource.class.getCanonicalName());
        if (currentResource != null) {
            resource = currentResource;
            Resource par = resource.getChild(JcrConstants.JCR_CONTENT + "/par");
            if (par.adaptTo(Node.class).getNodes().getSize() > 1) {
                type = "html";
            } else {
                Resource comp = par.listChildren().next();
                Component c = getResourceResolver().getResource(comp.getResourceType()).adaptTo(Component.class);
                if (c != null) {
                    type = c.getTitle();
                }
            }
        } else {
            LOGGER.error("No resource found in request");
        }
    }

    public String getCardTitle() {
        return getCurrentPage().getTitle();
    }

    public String getOfferPath() {
        return getCurrentPage().getPath();
    }

    public String getOfferType() {
        return type;
    }

    public String getLastModified() {
        RelativeTimeFormat rtf = new RelativeTimeFormat("r");
        Calendar cal = getCurrentPage().getLastModified();
        return rtf.format(cal.getTime().getTime(),true);
    }

    public Long getLastModifiedTimestamp() {
        return getCurrentPage().getLastModified().getTimeInMillis();
    }

}
