/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.personalization.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.ClientContextUtil;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * Implements the <code>&lt;personalisation:contextProfileAvatar/&gt;</code> tag
 * AdobePatentID="B1393"
 */
public class ContextProfileAvatarTag extends TagSupport {

    private static final long serialVersionUID = -8276659679028145718L;

    @SuppressWarnings("unused")
    private String avatarPath;
    private String defaultPath;
    private String store;
    private String avatarPropertyName;
    private String titlePropertyName;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        avatarPath = null;
        defaultPath = null;
        store = "profile";
        avatarPropertyName = "avatar";
        titlePropertyName = "formattedName";
    }


    public void setAvatarPath(String avatarPath) {
        this.avatarPath = avatarPath;
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setAvatarPropertyName(String avatarPropertyName) {
        this.avatarPropertyName = avatarPropertyName;
    }

    public void setTitlePropertyName(String titlePropertyName) {
        this.titlePropertyName = titlePropertyName;
    }

    @Override
    public int doEndTag() throws JspException {
        final JspWriter out = pageContext.getOut();
        final SlingHttpServletRequest request = TagUtil.getRequest(pageContext);
        try {
            out.println(getScript(request));

        } catch (IOException e) {
            throw new JspException("Could not write property value", e);
        }

        return EVAL_PAGE;
    }

    String getScript(SlingHttpServletRequest request) {

        SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);

        StringBuilder res = new StringBuilder();

        String id = store + "-avatar-" + ClientContextUtil.getId(request.getResource().getPath());
        res.append("<img id=\"").append(id).append("\">");

        res.append("<script type=\"text/javascript\">");
        res.append("$CQ(function() {");
        res.append("if( window.CQ_Analytics && CQ_Analytics.CCM) {");
        res.append("CQ_Analytics.ClientContextUtils.onStoreRegistered('")
                .append(store).append("', function(store) {");
        res.append("var renderer = function() {");
        res.append("var src = '").append(xssAPI.encodeForJSString(defaultPath)).append("';");
        res.append("src = store.getProperty('").append(xssAPI.encodeForJSString(avatarPropertyName)).append("') || src;");
        res.append("var title = store.getProperty('").append(xssAPI.encodeForJSString(titlePropertyName)).append("') || '';");
        res.append("var img = document.getElementById('").append(id).append("');");
        res.append("if( img ) {");
        res.append("if( img.src != src ) {");
        res.append("img.src = src;");
        res.append("}");
        res.append("if( img.title != title ) {");
        res.append("img.title = title;");
        res.append("img.alt = title;");
        res.append("}");
        res.append("}");
        res.append("};");
        res.append("renderer();");
        res.append("store.addListener('update', function() {");
        res.append("renderer();");
        res.append("});");
        res.append("});");
        res.append("}");
        res.append("});");
        res.append("</script>");

        return res.toString();
    }
}
