/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.personalization.ui.items;

import java.util.Set;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * Represents an interface for the activities page meta component which
 * implements the Granite UI 'foundation-collection-meta' behavior.
 */
@ConsumerType
public interface ActivityPageMeta {

    /**
     * Returns the title of the suffix resource.
     * 
     * @return Resource title
     */
    String getTitle();

    /**
     * Returns {@code true} if the current suffix resource is a folder.
     * 
     * @return {@code true} if suffix resource is a folder, {@code false} otherwise
     */
    boolean isFolder();

    /**
     * Returns a set of action relations which apply to the suffix resource.
     * 
     * @return A set of relation identifiers
     */
    Set<String> getActionRels();

}
