/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.personalization.ui.items;

import java.util.Calendar;
import java.util.List;

import org.osgi.annotation.versioning.ConsumerType;

/**
 * Represents an interface for the audiences and is intended to be used by UI.
 */
@ConsumerType
public interface Audience {

    /**
     * Returns the audience title
     * 
     * @return Title of the resource or the resource name if title is not available.
     */
    String getTitle();

    /**
     * Returns the path.
     * 
     * @return Path of the resource.
     */
    String getPath();

    /**
     * Returns the resource type.
     * 
     * @return Resource type of the resource.
     */
    String getResourceType();

    /**
     * Returns the last modified date.
     * 
     * @return Last modification date or {@code null}
     */
    Calendar getLastModified();

    /**
     * Returns the formatted user name by whom the item has been modified.
     * 
     * @return Formatted user name, identifier or {@code null}
     */
    String getLastModifiedBy();

    /**
     * Returns the last publication date.
     * 
     * @return Last publication date or {@code null}
     */
    Calendar getLastPublished();

    /**
     * Returns the formatted user name by whom the item has been published.
     * 
     * @return Formatted user name, identifier or {@code null}
     */
    String getLastPublishedBy();

    /**
     * Returns the applicable CSS classes.
     * 
     * @return Space separated CSS classes or an empty string
     */
    String getClasses();

    /**
     * Returns the audience type which can be either 'CC', 'CH', 'AT' or 'folder'.
     * 
     * @return Audience type
     */
    String getAudienceType();

    /**
     * Returns the audience JSON
     * 
     * @return Audience JSON or {@code null}
     */
    String getAudienceJson();

    /**
     * Returns the path to the cloud configuration.
     * 
     * @return Cloud configuration path or {@code null}
     */
    String getConfigPath();

    /**
     * Returns the navigator HREF attribute.
     * 
     * @return Navigator href attribute or {@code null}
     */
    String getNavigatorHref();

    /**
     * Returns the quick actions relations.
     * 
     * @return A list of quick actions relations or an empty list
     */
    List<String> getQuickactionsRels();

    /**
     * Return {@code true} if resource is editable.
     * 
     * @return {@code true} it resource is editable, {@code false} otherwise
     */
    boolean isEditable();

    /**
     * Returns {@code true} if resource is of type folder.
     * 
     * @return {@code true} if resource is a folder, {@code false} otherwise
     */
    boolean isFolder();

}
