/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.polling.importer;

import aQute.bnd.annotation.ProviderType;

/**
 * The <code>PollConfig</code> interface represents polling configurations
 * managed by the {@link PollingImporter} service.
 */
@ProviderType
public interface PollConfig {

    /**
     * Returns the identification path of this configuration.
     * 
     * @return Identification path
     */
    String getPath();

    /**
     * Returns the scheme. This is used to select the appropriate
     * {@link Importer} to handle polling the data source of this configuration.
     * 
     * @return String representation of the scheme
     */
    String getScheme();

    /**
     * Returns the data source URL. This is given to the {@link Importer}
     * handling the {@link #getScheme()} of this configuration to acquire the
     * data.
     * 
     * @return Data source URL
     */
    String getSource();

    /**
     * Returns the target path where the polled data is being stored. This is
     * used to create the <code>Resource</code> provided to the {@link Importer}
     * to import the data.
     * 
     * @return Target path
     */
    String getTarget();

    /**
     * The active poll interval in seconds of this configuration.
     * 
     * @return Active poll interval in seconds
     */
    long getInterval();

    /**
     * The stored poll interval in seconds of this configuration.
     * 
     * @return Stored poll interval in seconds
     */
    long getStoredInterval();
    
    /**
     * The enable state for the configuration.
     * 
     * @return Enabled state
     */
    public boolean isEnabled();
    
    /**
     * The login of this configuration.
     * 
     * @return Login name
     */
    public String getLogin();

    /**
     * The password of this configuration.
     * 
     * @return Password 
     */
    public String getPassword();

}