/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.replication;

import java.util.Map;

/**
 * <code>AgentConfigGroup</code>...
 */
public interface AgentConfigGroup {

    /**
     * Returns the id of this config group
     * @return the id
     */
    String getId();

    /**
     * Returns the name of this config group
     * @return the name
     */
    String getName();

    /**
     * Returns the title of this config group
     * @return the title
     */
    String getTitle();

    /**
     * Returns the run modes this group is active in
     * @return array of run mode names
     */
    String[] getRunModes();

    /**
     * Checks if this config group is active in respect to run modes. The group is active if at least one run mode
     * is currently active. Note that the run modes are evaluated when the agent config is created.
     * @return <code>true</code> if active
     */
    boolean isActive();

    /**
     * Returns the agent configurations that belong to this group.
     * @return map of configurations, key is the configuration path.
     */
    Map<String, AgentConfig> getConfigurations();
}