/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.replication;

/**
 * The <code>TransportHandler</code> is used to transport the replication
 * to the target host. A transport handler is created by a corresponding
 * {@link TransportHandler}.
 */
public interface TransportHandler {

    /**
     * Returns <code>true</code> if this transport handler can handle the given config.
     * @param config the config
     * @return <code>true</code> if this handler can handle the uri
     */
    boolean canHandle(AgentConfig config);

    /**
     * Delivers content to a subscriber.
     *
     * @param ctx transport context
     * @param tx the replication transaction
     * @throws ReplicationException if an error occurs.
     * @return the replication result of this operation.
     */
    ReplicationResult deliver(TransportContext ctx, ReplicationTransaction tx) throws ReplicationException;

}