/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.replication;

/**
 * This replication exception should be thrown, if the current
 * replication can't be retried at a later time as the error
 * is unrecoverable.
 * @since 5.4
 */
public class UnrecoverableReplicationException extends ReplicationException {

    private static final long serialVersionUID = -8617990791118342125L;

    /**
     * Creates a <code>ReplicationException</code> given
     * a message describing the failure cause
     * @param s description
     */
    public UnrecoverableReplicationException(String s) {
        super(s);
    }

    /**
     * Creates a <code>ReplicationException</code> given
     * a message describing the failure cause and a root
     * exception
     * @param s description
     * @param e root failure cause
     */
    public UnrecoverableReplicationException(String s, Exception e) {
        super(s, e);
    }

    /**
     * Creates a <code>ReplicationException</code> given
     * a root exception
     * @param e root failure cause
     */
    public UnrecoverableReplicationException(Exception e) {
        super(e);
    }
}
