/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface provides several extensions to reports that were introduced later and
 * were not added to the original {@link Report} interface to not break backward
 * compatibility.
 *
 * @since 5.5
 */
public interface ReportExtensions {

    /**
     * Gets the version of reporting a report has been created for.
     *
     * @return 0 for CQ 5.4, 1 for CQ 5.5
     */
    int getReportingVersion();

    /**
     * <p>Gets the time the report is created for.</p>
     *
     * <p>This is used for calculating time differences to "now", to have a single
     * reference for such calculations.</p>
     *
     * @return The time code (in milliseconds)
     */
    long getReportTimeReference();

}
