/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.reporting;

import org.apache.commons.mail.EmailException;

import javax.mail.internet.InternetAddress;
import java.io.Writer;
import java.util.List;

public interface RequestLogAnalyzer {

    String getRequestLogPath();

    void analyze(Writer out, int maxHours, int maxRequest, int maxResults) throws Exception;

    boolean cancelScheduledJob();

    String analyze(int maxHours, int maxRequests, int maxResults,
                   String hostName, List<InternetAddress> emailRecipients)
            throws EmailException, Exception;

    void analyzeScheduled(int maxHours, int maxRequests, int maxResults,
                          String hostName, List<InternetAddress> emailRecipients, String runDailyAt)
            throws EmailException, Exception;
}
