/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.htmlparser;

import java.io.IOException;


/**
 * Invoked by the <code>HTMLParser</code> when elements are scanned.
 * @deprecated This is replaced by the Apache Sling Html parsing.
 */
@Deprecated
public interface DocumentHandler {

    /**
     * Receive notification of unparsed character data.
     * @param ch   character data
     * @param off  offset where character data starts
     * @param len  length of character data
     * @throws IOException {@link IOException}
     */
    void characters(char[] ch, int off, int len) throws IOException;

    /**
     * Receive notification of the beginning of an element.
     * @param name     tag name
     * @param attList  attribute list
     * @param ch       string equivalent to this notification
     * @param off      offset where character data starts
     * @param len      length of character data
     * @param endSlash flag indicating whether the element is closed with
     *                 an ending slash (xhtml-compliant)
     * @throws IOException {@link IOException}
     */
    void onStartElement(String name, AttributeList attList, char[] ch,
			       int off, int len, boolean endSlash)
    throws IOException;

    /**
     * Receive notification of the end of an element.
     * @param name tag name
     * @param ch   string equivalent to this notification
     * @param off  offset where character data starts
     * @param len  length of character data
     * @throws IOException {@link IOException}
     */
    void onEndElement(String name, char[] ch, int off, int len)
    throws IOException;

    /**
     * Receive notification of parsing start.
     * @throws IOException {@link IOException}
     */
    void onStart() throws IOException;

    /**
     * Receive notification of parsing end.
     * @throws IOException {@link IOException}
     */
    void onEnd() throws IOException;
}
