/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;

import org.apache.sling.api.resource.Resource;

/**
 * The <code>LinkCheckerExtension</code> interface defines a plugin
 * for the {@link LinkChecker}. This allows to extend the link checking
 * through custom link checking mechanisms.
 * The link checker queries all extensions in no particular order as long
 * as the extensions return a valid link validity. As soon as the first
 * extension returns a different value, this value is returned.
 */
public interface LinkCheckerExtension {

    /**
     * This method checks if the passed resource is a valid resource.
     *
     * @param resource The resource to validate.
     * @return the validity information for this resource.
     */
    LinkValidity getLinkValidity(Resource resource);
}
