/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;

import org.apache.sling.api.SlingHttpServletRequest;


/**
 * The <code>LinkCheckerSettingsProvider</code> provides the settings
 * for the link checker with respect to the current request.
 * There can only be one provider - if no provider is registered
 * the link checker will use a default configuration.
 */
public interface LinkCheckerSettingsProvider {

    /**
     * Make linkchecker config available.
     * @param request the sling request
     * @return linkchecker config
     */
    LinkCheckerSettings createSettings(SlingHttpServletRequest request);
}