/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;


/**
 * Stores LinkInfo objects in the repository.
 */
public interface LinkInfoStorage {

    /**
     * Returns a list of links about which validity information is stored in the repository.
     *
     * @return A list of links
     */
    String[] getLinks();

    /**
     * Returns validity information for a specific link.
     *
     * @param url link to retrieve the information for
     * @return A LinkInfo object describing the link or null if no validity
     *         information exists for the link
     */
    LinkInfo getLinkInfo(String url);

    /**
     * Stores validity information about a link in the repository.
     *
     * @param info The validity information to be stored
     */
    void putLinkInfo(LinkInfo info);

    /**
     * Removes link validity information from the repository.
     *
     * @param info The validity information to be removed
     */
    void deleteLinkInfo(LinkInfo info);

    /**
     * Removes link validity information from the repository.
     *
     * @param url The URL for which the validity information is to be removed
     */
    void deleteLinkInfo(String url);

    /**
     * Forces the storageg to flush it's caches to the repository.
     * This should only be invoked by the external linkchecker task.
     */
    void sync();

}
