/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.linkchecker;

/**
 * <code>LinkRewriteConfig</code> holds the prefix and suffix strings for
 * links that are invalid, expired or predated.
 */
public class LinkRewriteConfig {

    /**
     * controls if the link should be removed
     */
    private final boolean remove;

    /**
     * prefix string
     */
    private final String prefix;

    /**
     * suffix string
     */
    private final String suffix;

    /**
     * Creates a new config.
     * @param remove indicates if the link should be removed
     * @param prefix prefix string
     * @param suffix suffix string
     */
    public LinkRewriteConfig(boolean remove, String prefix, String suffix) {
        this.remove = remove;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    /**
     * Controls if the link should be removed
     * @return <code>true</code> if the link should be removed
     */
    public boolean remove() {
        return remove;
    }

    /**
     * Returns the prefix string
     * @return prefix string
     */
    public String getPrefix() {
        return prefix;
    }

    /**
     * Returns the suffix string
     * @return suffix string
     */
    public String getSuffix() {
        return suffix;
    }
}