/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.pipeline;

import org.xml.sax.Attributes;

/**
 * A helper Class creating SAX Attributes
 * @deprecated Use the Apache Cocoon XML utilities instead.
 */
@Deprecated
public class AttributesImpl extends org.xml.sax.helpers.AttributesImpl {

    public static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();

    final static public String CDATA = "CDATA";
    final static public String ENTITY = "ENTITY";
    final static public String ENTITIES = "ENTITIES";
    final static public String ID = "ID";
    final static public String IDREF = "IDREF";
    final static public String IDREFS = "IDREFS";
    final static public String NAME = "NAME";
    final static public String NAMES = "NAMES";
    final static public String NMTOKEN = "NMTOKEN";
    final static public String NMTOKENS = "NMTOKENS";
    final static public String NOTATION = "NOTATION";
    final static public String NUMBER = "NUMBER";
    final static public String NUMBERS = "NUMBERS";
    final static public String NUTOKEN = "NUTOKEN";
    final static public String NUTOKENS = "NUTOKENS";

    /**
     * Utility method to update the value of the named attribute. Returns
     * an updated set of attributes instead of modifying the given attribute
     * set as the given value may be read-only.
     *
     * @param attributes original set of attributes
     * @param name attribute name
     * @param value new attribute value
     * @return updated set of attributes
     */
    public static Attributes update(
            Attributes attributes, String name, String value) {
        AttributesImpl update = new AttributesImpl(attributes);
        int index = update.getIndex(name);
        if (index != -1) {
            update.setValue(index, value);
        } else {
            update.addCDATAAttribute(name, value);
        }
        return update;
    }

    /**
     * Constructor
     */
    public AttributesImpl() {
        super();
    }

    /**
     *  Constructor
     *  @param attr {@link Attributes}
     */
    public AttributesImpl(Attributes attr) {
        super(attr);
    }

    /**
	 * Add an attribute of type CDATA with empty Namespace to the end of the list.
	 *
	 * <p>For the sake of speed, this method does no checking
	 * to see if the attribute is already in the list: that is
	 * the responsibility of the application.</p>
	 *
	 * @param localName The local name.
	 * @param value The attribute value.
	 */
	public void addCDATAAttribute(String localName, String value) {
		addAttribute("", localName, localName, CDATA, value);
	}

    /**
     * Add an attribute of type CDATA with the namespace to the end of the list.
     *
     * <p>For the sake of speed, this method does no checking
     * to see if the attribute is already in the list: that is
     * the responsibility of the application.</p>
     *
     * @param namespace The namespace.
     * @param localName The local name.
     * @param value The attribute value.
     */
    public void addCDATAAttribute(String namespace, String localName, String value) {
        addAttribute(namespace, localName, localName, CDATA, value);
    }

	/**
	 * Add an attribute of type CDATA to the end of the list.
	 *
	 * <p>For the sake of speed, this method does no checking
	 * to see if the attribute is already in the list: that is
	 * the responsibility of the application.</p>
	 *
	 * @param uri The Namespace URI, or the empty string if
	 *        none is available or Namespace processing is not
	 *        being performed.
	 * @param localName The local name, or the empty string if
	 *        Namespace processing is not being performed.
	 * @param qName The qualified (prefixed) name, or the empty string
	 *        if qualified names are not available.
	 * @param value The attribute value.
	 */
	public void addCDATAAttribute(String uri,
                                  String localName,
                                  String qName,
                                  String value) {
		addAttribute(uri, localName, qName, CDATA, value);
	}

    /**
     * Remove an attribute
     * @param localName The attribute's local name.
     */
    public void removeAttribute(String localName) {
        final int index = this.getIndex(localName);
        if ( index != -1 ) {
            this.removeAttribute(index);
        }
    }

    /**
     * Remove an attribute
     * @param uri The attribute's Namespace URI, or the empty
     *        string if none is available.
     * @param localName The attribute's local name.
     */
    public void removeAttribute(String uri, String localName) {
        final int index = this.getIndex(uri, localName);
        if ( index != -1 ) {
            this.removeAttribute(index);
        }
    }
}
