/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.facets;

import java.util.List;

/**
 * <code>Facet</code> represents a single category that splits up a search
 * result into multiple {@link Bucket buckets}.
 */
public interface Facet {

    /**
     * Returns the buckets for this facet.
     *
     * @return the buckets for this facet.
     */
    List<Bucket> getBuckets();

    /**
     * @return <code>true</code> if any of the buckets contains a hit,
     *          <code>false</code> otherwise.
     */
    boolean getContainsHit();
}
