/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.result;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import java.util.Map;

/**
 * <code>Hit</code> represents a single search result, ie. a node and resource.
 */
public interface Hit {

    /**
     * @return the zero based index for this hit in the query result.
     */
    long getIndex();

    /**
     * @return a map with excerpts on the jcr:content node of a page.
     * @throws RepositoryException if an error occurs while building the
     *                             map.
     */
    Map<String, String> getExcerpts() throws RepositoryException;

    /**
     * @return the default excerpt for this hit.
     * @throws RepositoryException if an error occurs while building the
     * excerpt.
     */
    String getExcerpt() throws RepositoryException;

    /**
     * @return the resource this hit represents.
     * @throws RepositoryException if an error occurs while reading from the
     *                             query result.
     */
    Resource getResource()
            throws RepositoryException;
    
    /**
     * @return the node behind this hit
     * @throws RepositoryException if an error occurs while reading from the
     * repository.
     * 
     * @since 5.2
     */
    Node getNode() throws RepositoryException;

    /**
     * @return the path of the current hit.
     * @throws RepositoryException if an error occurs while reading from the
     * query result.
     */
    String getPath() throws RepositoryException;

    /**
     * Returns either the properties of the <code>jcr:content</code> subnode
     * (if present) or the properties of this node itself.
     * 
     * @return the properties on this hit
     * @throws RepositoryException if an error occurs while reading from the
     * repository.
     * 
     * @since 5.2 (previously returned a plain {@link Map})
     */
    ValueMap getProperties() throws RepositoryException;

    /**
     * Returns the title for this hit. The returned string may contain
     * HTML tags, which means it must not be escaped when written to the
     * response.
     *
     * @return the title for this hit.
     * @throws RepositoryException if an error occurs while reading form the
     * repository.
      */
    String getTitle() throws RepositoryException;

    /**
     * Returns the full text search score for this hit.
     *
     * @return a double.
     * @throws RepositoryException if an error occurs while reading form the
     * repository.
     * 
     * @since 6.0 (bundle version 5.7.2, package version 1.1.0)
     */
    double getScore() throws RepositoryException;
}
