/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security;

import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;

import javax.jcr.AccessDeniedException;

import org.apache.sling.api.adapter.Adaptable;

import com.day.cq.security.privileges.Privilege;
import com.day.cq.security.profile.Profile;

/**
 * Base Class for Objects which act on the Repository.
 * This can be {@link User Users}, eg. the authenticated
 * subject, or {@link Group Groups} of Users.
 * The Authorizable is related to a {@link javax.jcr.Session Session} via
 * the {@link javax.jcr.Session#getUserID() User-ID}.<br>
 * Allow to adapt the Authorizable to Other resources like its Home, Preferences etc.
 *
 * @see Adaptable
 * @deprecated cq 5.5 Use org.apache.jackrabbit.api.security.user.Authorizable instead.
 */
public interface Authorizable extends Adaptable {

    final String PROPERTY_PRINCIPAL = "rep:principalName";

    /**
     * @deprecated UserID is not stored as separate property any more.
     */
    @Deprecated
    final String PROPERTY_ID = "rep:userId";

    final String PROPERTY_PASSWORD = "rep:password";

    final String PROPERTY_IMPERSONATORS = "rep:impersonators";
    /**
     * @deprecated no longer stored in the authorizable properties but only in the profile
     */
    @Deprecated
    final String PROPERTY_NAME = "rep:fullname";
    /**
     * @deprecated no longer stored in the authorizable properties but only in the profile
     */
    @Deprecated
    final String PROPERTY_DESCRIPTION = "rep:description";
    /**
     * @deprecated no longer stored in the authorizable properties but only in the profile
     */
    @Deprecated
    final String PROPERTY_EMAIL = "rep:e-mail";
    /**
     * @deprecated no longer stored in the authorizable properties but only in the profile
     */
    @Deprecated
    final String PROPERTY_FIRST_NAME = "cq:first-name";
    /**
     * @deprecated no longer stored in the authorizable properties but only in the profile
     */
    @Deprecated
    final String PROPERTY_LAST_NAME = "cq:last-name";

    /**
     * If an Authorizable is a {@link User User} according
     * this test-method a cast to {@link User User Class}
     * MUST be possible.
     *
     * @return true if the Authorizable is a User
     * @see User
     */
    boolean isUser();

    /**
     * The ID is a unique identifier within the
     * {@link UserManager UserManager} this User has been
     * acquired from.<br>
     * The following must be true:
     * <pre>
     *  String id = "userId"
     *  User u = userManger.get(id);
     *  u.extractID().equals(id);
     * </pre>
     *
     * @return the ID of this User.
     * @see UserManager#get(String)
     */
    String getID();

    /**
     * A human readable Name.
     * E.g. Implementations may return the full name of a User
     *
     * @return full name of this authorizable
     */
    String getName();

    /**
     * @return this Authorizable holds, if authenticated
     */
    Principal getPrincipal();

    /**
     * Returns the names of properties present with <code>this</code> Authorizable.
     *
     * @return names of properties.
     * @see #getProperty(String)
     */
    Iterator<String> getPropertyNames();

    /**
     * Retrieve the property value with the given name.
     *
     * @param name of the Property
     * @return Property or <code>null</code>if property does not exist or does not have a value
     */
    String getProperty(String name);

    /**
     * Set an arbitrary property to this <code>Authorizable</code>.
     *
     * @param name  name of the Property to set
     * @param value to set
     * @throws AccessDeniedException the editing session isn't allowed to write.
     */
    void setProperty(String name, String value) throws AccessDeniedException;


    /**
     * Removes the property with the given name.
     *
     * @param name of the Property to remove
     * @return true If the property with the specified name was successfully
     *         removed; false if no such property was present.
     * @throws AccessDeniedException the editing session isn't allowed to write.
     */
    boolean removeProperty(String name) throws AccessDeniedException;


    /**
     * The Groups a Authorizable is member of.<br>
     * Transitive membership is not resolved.
     * Thus the following is true:
     * if Authorizable A is member of Group G
     * g.members() contains A.
     *
     * @return Iterator containing all Groups the Authorizable is direct member of
     */
    Iterator<Group> memberOf();

    /**
     * @return an absolute Path, this User may use as Home-Directory
     */
    String getHomePath();

    /**
     * @param privilege identifier of the privilege (eg. workflow/privilege/start)
     * @return true if the privilege is set. false if not or
     *         if {@link Privilege#isPathDependent()} privilege is pathDependant}
     * @see #grantPrivilege(String)
     * @deprecated CQ 5.5
     */
    boolean hasPermission(String privilege);

    /**
     * @param privilege    identifier of the privilege (eg. workflow/privilege/start)
     * @param resourcePath path of the resource
     * @return true if the privilege is set.
     *         if {@link Privilege#isPathDependent()} privilege is pathDependant}.
     *         it has additionaly to grant on the given resource-path
     * @see #grantPrivilege(String)
     * @see Privilege#isGranted(String)
     * @deprecated CQ 5.5
     */
    boolean hasPermissionOn(String privilege, String resourcePath);

    /**
     * @param privilege identifier of the privilege (eg. workflow/privilege/start)
     * @return Privilege or null if none set
     * @throws AccessDeniedException in case the session that acquired
     *                               this authorizable is not allowed read Privileges
     * @see #grantPrivilege(String)
     * @deprecated CQ 5.5
     */
    Privilege getPrivilege(String privilege) throws AccessDeniedException;

    /**
     * @param privilege identifier to grant the current Authorizable
     * @throws AccessDeniedException in case the session that acquired
     *                               this authorizable is not allowed grant Privileges
     * @deprecated CQ 5.5
     */
    void grantPrivilege(String privilege) throws AccessDeniedException;

    /**
     * @param privilege identifier of the privilege to remove from this Authorizable
     * @throws AccessDeniedException in case the session that acquired
     *                               this authorizable is not allowed revoke Privileges
     * @deprecated CQ 5.5
     */
    void revokePrivilege(String privilege) throws AccessDeniedException;

    /**
     * @return collection of Privileges granted the current Authorizable
     *         this includes only the privileges granted explicitly and not those
     *         granted by group-membership.
     * @throws AccessDeniedException in case the session that acquired
     *                               this authorizable is not allowed read Privileges
     * @deprecated CQ 5.5
     */
    Collection<Privilege> getPrivileges() throws AccessDeniedException;

    /**
     * Default profile for this Authorizable
     *
     * @return or <code>null</code> if there is no Profile for this Authorizable
     * @see com.day.cq.security.profile.ProfileManager#getProfile(String, javax.jcr.Session)
     */
    Profile getProfile();

    /**
     * delete this Authorizable
     *
     * @throws AccessDeniedException in case the session that acquired
     *                               this authorizable is not allowed to remove this
     */
    void remove() throws AccessDeniedException;
}
