/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security;

import javax.jcr.AccessDeniedException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;

/**
 * A User is an Authorizable that may Authenticate.
 * This User authenticates by its Password.
 * It therefor extends the Authorizable by a method to save a Password
 *
 * @see Authorizable
 * @deprecated cq 5.5 Use org.apache.jackrabbit.api.security.user.User instead.
 */
public interface User extends Authorizable {

    /**
     * Grant an {@link Authorizable Authorizable} the privilege to impersonate
     * as this User.<br>
     * <i><b>NOTE</b>: you can't grant impersonation from the User to the User itself.
     * Implementations have to return false in this case.
     *
     * @param authorizable the Impersonation should be granted
     * @return true if newly added.
     * @throws AccessDeniedException if privileges are not sufficient
     */
    boolean grantImpersonation(Authorizable authorizable) throws AccessDeniedException;

    /**
     * Revoke the given {@link Authorizable Authorizanle} the privilege to
     * impersonate as this {@link com.day.cq.security.User User}.<br>
     * <i><b>NOTE</b>: you can't revoke impersonation from the User to the User itself.</i>
     *
     * @param authorizable to remove the Privilege
     * @return true if tha given Authoirzable has had the privilege
     * @throws AccessDeniedException in case the caller does not the permission
     *                               to perform this action
     */
    boolean revokeImpersonation(Authorizable authorizable) throws AccessDeniedException;

    /**
     * Access all {@link Authorizable Authorizables} that are allowed to
     * impersonate as this {@link com.day.cq.security.User User}.
     * The collection will only contain the Authorizables the caller has permissions
     * to read
     *
     * @return Authorizables allowed to impersonate as this User
     */
    Iterator<? extends Authorizable> getImpersonators();

    /**
     * Return the Ids of all Authorizables that this User is allowed to impersonate
     * as
     *
     * @return list of all IDs of User it may be allowed to sudo
     */
    Iterator<String> getSudoableUsers();

    /**
     * @param password considered plain
     * @param digest   to use for encryption of the given password.
     * @throws NoSuchAlgorithmException if the digest is not registered as a MessageDigest
     * @throws javax.jcr.AccessDeniedException In case of missing permissions.
     * @deprecated
     */
    @Deprecated
    void setPassword(String password, String digest) throws NoSuchAlgorithmException, AccessDeniedException;

    /**
     * @param password considered plain
     */
    void changePassword(String password);

    /**
     * @see org.apache.jackrabbit.api.security.user.User#disable(String)
     * @since 5.4
     */
    void disable(String reason) throws javax.jcr.RepositoryException;

    /**
     * @see org.apache.jackrabbit.api.security.user.User#isDisabled()
     * @since 5.4
     */
    boolean isDisabled() throws javax.jcr.RepositoryException;

    /**
     * @see org.apache.jackrabbit.api.security.user.User#getDisabledReason()
     * @since 5.4
     */
    String getDisabledReason() throws javax.jcr.RepositoryException;
}
