/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.privileges;

import java.util.Collection;

import javax.jcr.AccessDeniedException;
import javax.jcr.Session;

import com.day.cq.security.Authorizable;
import com.day.cq.security.NoSuchPrivilegeException;

/**
 * Allows to access, test and modify the Privileges of given
 * {@link Authorizable Authorizables}<br>
 * Accss rights of the given {@link javax.jcr.Session Session} are enforced.
 *
 * The Authorizable related methods can be invoked upon the related Authorizable
 *
 * @see Authorizable
 * @deprecated CQ 5.5
 */
public interface PrivilegeManager {

    /**
     * Retrieve the Privilege with the given path for the given authorizable,
     * use the Session to access the repository
     *
     * @param privPath identifier of the privilege
     * @param auth to accss the privilieg for
     * @param session Session to access the access the repository
     * @return Privilege if one defined or <code>null</code> if none set
     * @throws AccessDeniedException in case Session misses privileges to access
     */
    Privilege getPrivilege(String privPath, Authorizable auth, Session session)
            throws AccessDeniedException;

    /**
     * Set the given Privilege to the Authorizable with the given session
     *
     * @param privPath identifier of the privilege
     * @param auth authorizable to set the privilege to
     * @param session session to set the privilege with
     * @return Privilge newly set 
     * @throws AccessDeniedException in case session misses privileges to grant Privileg
     * @throws NoSuchPrivilegeException in case the given privilege identifier is unknown 
     */
    Privilege grantPrivilege(String privPath, Authorizable auth, Session session)
            throws AccessDeniedException, NoSuchPrivilegeException;

    /**
     * Revkes the given privilge from the authorizables
     * @param privilege to remove
     * @param auth the authorizable to remove the Privilege from
     * @param session to perform the operation
     * @throws AccessDeniedException
     *          in case the Session lacks access right to revkoe Privileges
     */
    void revokePrivilege(Privilege privilege, Authorizable auth, Session session)
            throws AccessDeniedException;

    /**
     * Access all privilages an Authorizable are granted.
     * @param authorizable to query
     * @param session to query with
     * @return all granted Privilages of the given Authorizable
     * @throws AccessDeniedException in case the Session lacks access rights
     */
    Collection<Privilege> getPrivileges(Authorizable authorizable, Session session)
            throws AccessDeniedException;

    /**
     * @param session to use for query
     * @return all Priviliges identifiers that are known to this Manager
     * @throws AccessDeniedException in case Session lacks acces rights
     */
    Collection<String> getPrivileges(Session session) throws AccessDeniedException;
}
