/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.util;

import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;

import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import java.util.ArrayList;
import java.util.List;

/**
 * Littel tool to configure an ACL. To be set on the
 * {@link com.day.cq.security.util.CRXPolicyManager CRXPolicyManager}.
 * The Lists entries are ordered in the the sequence they have been added on this
 * Object
 *
 * @deprecated Since CQ 5.3 Please use JCR API instead.
 */
@Deprecated
public class AclPolicy {

    private final List<Entry> entries = new ArrayList<Entry>();

    public AclPolicy() {};
    
    public AclPolicy(String principal, String[] privilegeNames, boolean allow) {
        if (allow) {
            allow(principal, privilegeNames);
        } else {
            deny(principal, privilegeNames);
        }
    }

    public void allow(String principal, String... privilegeNames) {
        entries.add(new Entry(principal, privilegeNames, true));
    }

    public void deny(String principal, String... privilegeNames) {
        entries.add(new Entry(principal, privilegeNames, false));
    }

    /**
     * Method to set a {@link javax.jcr.security.AccessControlEntry AccessControlEntry}
     * to the current Policy
     * 
     * @param ace to set to this Policy
     * @since 5.3
     */
    public void addAce(AccessControlEntry ace) {
        Privilege[] privs = ace.getPrivileges();
        String[] privNames = new String[privs.length];
        for(int i=0;i<privs.length;i++) {
            privNames[i] = privs[i].getName();
        }
        if (ace instanceof JackrabbitAccessControlList) {
            if (((JackrabbitAccessControlEntry)(ace)).isAllow()) {
                allow(ace.getPrincipal().getName(), privNames);
            } else {
                deny(ace.getPrincipal().getName(), privNames);
            }
        } else {
            allow(ace.getPrincipal().getName(), privNames);
        }
    }

    /**
     * @return the entries of the ACL
     */
    protected List<Entry> getEntries() {
        return entries;
    }

    //------------------------------------------------< List Entry >------------
    final static class Entry {

        private final String principal;
        private final boolean allow;
        private final String[] privileges;

        private Entry(String principal, String[] privilegeNames, boolean allow) {
            this.principal = principal;
            this.allow = allow;
            this.privileges = privilegeNames;
        }

        public String getPrincipal() {
            return principal;
        }

        public boolean isAllow() {
            return allow;
        }

        public String[] getPrivileges() {
            return privileges;
        }
    }
}
