/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.spellchecker.spi;

import aQute.bnd.annotation.ConsumerType;

/**
 * Generic spellchecker interface, returned by a {@link SpellCheckerProvider
 * spellchecker provider}.
 */
@ConsumerType
public interface SpellChecker {

    /**
     * Check a word against the spellchecker. Return <code>true</code> if the
     * word is correct, else <code>false</code>
     *
     * @param word word to check
     * @return a flag indicating, whether the word is correct
     */
    public abstract boolean check(String word);

    /**
     * Return spelling suggestions for a word. Takes a word and an empty
     * suggestion list as arguments. Returns the number of suggestions found and
     * filled into the suggestion list.
     *
     * @param word word to find suggestions for
     * @param suggestions list of suggestions to be filled
     * @return number of suggestions found and filled into the suggestions array
     */
    public abstract int suggest(String word, String suggestions[]);
}
