package com.day.cq.wcm.api;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.commons.predicate.AbstractNodePredicate;

/**
 * Predicate used to filter Template nodes.
 * @deprecated use {@link PageNodePredicate} instead
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "page")
})
@Deprecated
public class IsPageNodePredicate extends AbstractNodePredicate implements Predicate {

    /**
     * default logger
     */
    private final Logger log = LoggerFactory.getLogger(IsPageNodePredicate.class);

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is an nt:folder containing templates or cq:Template node.
     * @deprecated use {@link PageNodePredicate#test(Node)} instead
     */
    @Deprecated
    public boolean evaluate(Node node) throws RepositoryException {
        log.warn("IsPageNodePredicate has been deprecated. Please use com.day.cq.wcm.api.PageNodePredicate instead.");

        String primaryName = node.getPrimaryNodeType().getName();

        if (primaryName.equals("cq:Page")) {
            return true;
        }
        if (primaryName.equals(JcrConstants.NT_FOLDER) || primaryName.equals("sling:Folder") || primaryName.equals("sling:OrderedFolder")) {
            return node.hasNodes();
        }
        return false;
    }
}
