/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.wcm.api.components;

/**
 * Defines the layout of the "editing" where "rollover" means that there is a
 * rollover edit capability on the component and "edit bar" means that there is
 * a edit bar.
 */
public enum EditLayout {

    /**
     * rollover editing type
     */
    ROLLOVER("editrollover"),

    /**
     * edit bar
     */
    EDITBAR("editbar"),

    /**
     * automatic detection
     */
    AUTO(""),

    /**
     * no explicit edit controls; will be provided externally by the page/other parent
     * component
     * @since 5.4
     */
    NONE("editnocontrol");

    /**
     * the ext type
     */
    private final String xtype;

    /**
     * internal constructor for the refresh context
     * @param xtype the javascript type
     */
    EditLayout(String xtype) {
        this.xtype = xtype;
    }

    /**
     * Returns the xtype
     * @return the xtype
     */
    public String getXtype() {
        return xtype;
    }
}