/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2022 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api.constants;

import com.day.cq.commons.jcr.JcrConstants;

/**
 * Constants for jcr names used in cq. conventions:
 * <ul>
 * <li>NT_ prefix stands for "node type"
 * <li>NN_ prefix stands for "node name"
 * <li>PN_ prefix stands for "property name"
 * <li>Constants all uppercase
 * <li>"replace" intercaps by underscores. eg: PN_PAGE_TITLE = "PageTitle"
 * </ul>
 *
 * Replaces {@link com.day.cq.wcm.api.NameConstants}
 */
public final class NameConstants {
    public static final String NT_PAGE = "cq:Page";
    public static final String NT_PSEUDO_PAGE = "cq:PseudoPage";
    public static final String NT_TEMPLATE = "cq:Template";
    public static final String NT_COMPONENT = "cq:Component";
    public static final String NT_EDIT_CONFIG = "cq:EditConfig";

    // component
    public static final String NN_CONTENT = JcrConstants.JCR_CONTENT;
    public static final String NN_DIALOG = "dialog";
    public static final String PN_DIALOG_PATH = "dialogPath";
    public static final String NN_DESIGN_DIALOG = "design_dialog";
    public static final String PN_DESIGN_DIALOG_PATH = "designDialogPath";
    public static final String NN_EDIT_CONFIG = "cq:editConfig";
    public static final String NN_CHILD_EDIT_CONFIG = "cq:childEditConfig";
    public static final String NN_ICON_PNG = "icon.png";
    public static final String NN_THUMBNAIL_PNG = "thumbnail.png";
    public static final String PN_CELL_NAME = "cq:cellName";
    public static final String PN_IS_CONTAINER = "cq:isContainer";
    public static final String PN_NO_DECORATION = "cq:noDecoration";
    public static final String NN_HTML_TAG = "cq:htmlTag";
    public static final String PN_ALLOWED_PATHS = "allowedPaths";
    public static final String PN_ALLOWED_CHILDREN = "allowedChildren";
    public static final String PN_ALLOWED_PARENTS = "allowedParents";
    public static final String PN_COMPONENT_GROUP = "componentGroup";
    public static final String PN_RANKING = "ranking";
    public static final String PN_SITE_PATH = "sitePath";
    public static final String NN_PARAMS = "params";
    public static final String NN_VIRTUAL = "virtual";
    public static final String PN_TEMPLATE_PATH = "cq:templatePath";
    public static final String NN_TEMPLATE = "cq:template";
    public static final String PN_TAG_NAME = "cq:tagName";
    public static final String NN_INFO_PROVIDERS = "cq:infoProviders";
    public static final String PN_CLASS_NAME = "className";
    /** @since 6.1 */
    public static final String PN_DELETED = "deleted";
    public static final String PN_DELETED_BY = "deletedBy";

    /**
     * The node will contain all necessary information
     * needed to support responsive authoring functionality
     * like responsive grid, media query breakpoints etc
     * @since 6.1
     */
    public static final String NN_RESPONSIVE_CONFIG = "cq:responsive";

    /**
     * The node will contain all authoring related features
     * which DO NOT have impact on the rendering or logic of component
     * but on the behavior of the authoring UI
     * @since 6.1
     */
    public static final String NN_AUTHORING_CONFIG = "cq:authoring";


    /** @since 5.6 */
    public static final String PN_DISABLE_TARGETING = "cq:disableTargeting";

    // editing
    public static final String PN_LAYOUT = "cq:layout";
    public static final String PN_DIALOG_MODE = "cq:dialogMode";
    /** @since 5.3 */
    public static final String NN_INPLACE_EDITING = "cq:inplaceEditing";
    public static final String PN_EMPTY_TEXT = "cq:emptyText";
    public static final String PN_ACTIONS = "cq:actions";
    public static final String NN_ACTION_CONFIGS = "cq:actionConfigs";
    public static final String NN_FORM_PARAMETERS = "cq:formParameters";
    public static final String NN_DROP_TARGETS = "cq:dropTargets";
    public static final String NN_LISTENERS = "cq:listeners";
    public static final String PN_DT_NAME = "propertyName";
    public static final String PN_DT_ACCEPT = "accept";
    public static final String PN_DT_GROUPS = "groups";
    public static final String NN_DT_PARAMETERS = "parameters";
    /** @since 5.4 */
    public static final String PN_INHERIT = "cq:inherit";
    /** @since 6.3 */
    public static final String PN_ORDER = "order";

    /**
     * This property can contain the location of a redirect target
     * @since 1.0.0
     */
    public static final String PN_REDIRECT_TARGET = "cq:redirectTarget";
    /**
     * This property defines if the redirect should be permanent or temporary
     * @since 1.0.0
     */
    public static final String PN_REDIRECT_PERMANENT = "cq:redirectPermanent";

    // designer
    public static final String PN_DESIGN_PATH = "cq:designPath";

    // versioning
    public static final String PN_PARENT_PATH = "cq:parentPath";
    public static final String PN_NAME = "cq:name";
    public static final String PN_CHILDREN_ORDER = "cq:childrenOrder";
    public static final String PN_SIBLING_ORDER = "cq:siblingOrder";
    public static final String PN_VERSION_COMMENT = "cq:versionComment";

    // misc
    public static final String PN_TITLE = JcrConstants.JCR_TITLE;
    public static final String PN_SHORT_TITLE = "shortTitle";
    public static final String PN_PAGE_TITLE = "pageTitle";
    public static final String PN_TEMPLATE = "cq:template";
    public static final String PN_NAV_TITLE = "navTitle";
    public static final String PN_DESCRIPTION = JcrConstants.JCR_DESCRIPTION;
    public static final String PN_HIDE_IN_NAV = "hideInNav";
    public static final String PN_LAST_MOD = JcrConstants.JCR_LASTMODIFIED;
    public static final String PN_LAST_MOD_BY = JcrConstants.JCR_LAST_MODIFIED_BY;
    public static final String PN_CREATED = JcrConstants.JCR_CREATED;
    public static final String PN_CREATED_BY = JcrConstants.JCR_CREATED_BY;
    public static final String PN_ON_TIME = "onTime";
    public static final String PN_OFF_TIME = "offTime";
    public static final String PN_PAGE_LAST_MOD = "cq:lastModified";
    public static final String PN_PAGE_LAST_MOD_BY = "cq:lastModifiedBy";
    public static final String PN_PAGE_LAST_REPLICATED = "cq:lastReplicated";
    public static final String PN_PAGE_LAST_REPLICATED_BY = "cq:lastReplicatedBy";
    public static final String PN_PAGE_LAST_REPLICATION_ACTION= "cq:lastReplicationAction";
    public static final String PN_TAGS = "cq:tags";
    public static final String PN_DEFAULT_VIEW = "cq:defaultView";
    public static final String PN_SLING_VANITY_PATH = "sling:vanityPath";

    /** @since 5.3 */
    public static final String PN_ALLOWED_TEMPLATES = "cq:allowedTemplates";
}
