/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.designer;

import java.util.Iterator;

/**
 * Represents a cell on the cell stack.
 */
public interface Cell {

    /**
     * Returns the primary name of this cell
     * @return the primary name of this cell
     */
    String getName();

    /**
     * Returns the names of this cell
     * @return the names of this cell
     */
    String[] getNames();

    /**
     * Returns the paths of this cell
     * @return the paths of this cell.
     *
     * @deprecated since 5.4. use {@link #paths()} instead.
     */
    String[] getPaths();

    /**
     * Returns an iterator over all cell paths. The paths are considered
     * relative to a design page's content.
     * @return an iterator over all cell paths.
     *
     * @since 5.4
     */
    Iterator<String> paths();

    /**
     * Returns the primary path of this cell. The path is considered
     * relative to a design page's content.
     * @return the primary path.
     *
     * @since 5.4
     */
    String getPath();

    /**
     * Returns the search paths.
     * @return the search paths.
     *
     * @deprecated since 5.4. use {@link #searchPaths()} instead.
     */
    String[] getSearchPaths();

    /**
     * Returns an iterator over the style search paths.
     * @return the style search paths.
     *
     * @since 5.4
     */
    Iterator<String> searchPaths();

    /**
     * Returns an expression for the search path.
     * @return search path expression
     */
    String getSearchPath();

    /**
     * Returns the parent cell of the cell stack or <code>null</code> if
     * this cell is the top most.
     * @return parent cell or <code>null</code>
     */
    Cell getParent();
}