/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.wcm.api.designer;

import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.Resource;

/**
 * A style contains properties that reflect the design aspect of a cell.
 */
public interface Style extends ValueMap {

    /**
     * Returns the design this style is defined in.
     * @return the design.
     */
    Design getDesign();

    /**
     * Returns the path to this cell resource
     * @return the path
     */
    String getPath();

    /**
     * Returns the cell of this style
     * @return the cell
     */
    Cell getCell();

    /**
     * Return named value converted to type T or
     * <code>null</code> if not existing.
     *
     * Please note that this also supports a {@link Resource} class as type
     * in order to retrieve a style resource (e.g. image)
     *
     * @param name the name of the property or resource
     */
    <T> T get(String name, Class<T> type);

    /**
     * return named value converted to the type T of
     * the default value or the default value if the
     * named value does not exist
     *
     * @param name the name of the property
     * @param defaultValue the default value
     * @return the value.
     */
    <T> T get(String name, T defaultValue);

    /**
     * Returns the resource that defines the style property with the given name.
     * @param name name of the style property
     * @return resource or <code>null</code>
     */
    Resource getDefiningResource(String name);

    /**
     * Returns the cell path that defines the style property with the given name.
     * @param name name of the style property
     * @return path or <code>null</code>
     */
    String getDefiningPath(String name);

    /**
     * Returns a sub style for the give one, by virtually extending the cell
     * stack.
     *
     * @param relPath relative path of the sub style.
     * @return the new style
     */
    Style getSubStyle(String relPath);

}