/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.msm;

import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.wcm.api.WCMException;

/**
 * Represent an rollout action. Action is executed by <code>RolloutManager</code> through the <code>ActionManager</code>.
 * @see com.day.cq.wcm.api.msm.RolloutManager
 * @see com.day.cq.wcm.api.msm.ActionManager
 * @deprecated since 5.3 use {@link com.day.cq.wcm.msm.api.LiveAction} instead 
 */
@Deprecated
public interface LiveAction {
    /**
     * Returns name of current action. Name is used to persist action in the repository.
     * @return action name
     */
    public String getName();

    /**
     * Executes action. Is called by the Rollout Manager.
     * @see ActionManager#executeActions(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, boolean)
     * @see ActionManager#executeAction(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean)
     * @param resolver resource resolver
     * @param relation live relationship concerned by action.
     * @param config action config
     * @param autoSave Save modifications
     * @throws WCMException if an error occurs
     */
    public void execute(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave) throws WCMException;

    /**
     * Executes action. Is called by the Rollout Manager.
     * @see ActionManager#executeActions(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, boolean, boolean)
     * @see ActionManager#executeAction(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean, boolean)
     * @param resolver resource resolver
     * @param relation live relationship concerned by action.
     * @param config action config
     * @param autoSave Save modifications
     * @param isResetRollout True if rollout is run in reset mode
     * @throws WCMException if an error occurs
     */
    public void execute(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave, boolean isResetRollout) throws WCMException;

    /**
     * Returns execution rank of the action: actions are executed by ascending ranks
     * @return action rank
     */
    public int getRank();

    /**
     * Returns names of the properties defined for this action.
     * @return array of parameters names
     */
    public String[] getPropertiesNames();

    /**
     * Returns the global parameter name of current action. Parameter name is used in requests.
     * @return action parameter name
     */
    public String getParameterName();
}
