/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api.msm;

import java.util.List;
import java.util.Map;

import com.day.cq.commons.JSONItem;

/**
 * @deprecated since 5.3 use {@link com.day.cq.wcm.msm.api.LiveStatus} instead 
 */
@Deprecated
public interface LiveStatus extends JSONItem {
    /**
     * Returns true if relationship is cancelled
     * @return true if relationship is cancelled
     */
    public boolean isCancelled();

    /**
     * Returns true if relationship is cancelled for children relationships. Only possible if isCancelled() is true.
     * @return true if relationship is cancelled for children relationships
     */
    public boolean isCancelledForChildren();

    /**
     * Returns true if relationship can be edited, ie can be cancelled.
     * @return true if relationship can be edited
     */
    public boolean isEditable();

    /**
     * Returns true if relationship's source exists
     * @return true if relationship's source exists
     */
    public boolean isSourceExisting();

    /**
     * Returns true if relationship's target exists
     * @return true if relationship's target exists
     */
    public boolean isTargetExisting();

    /**
     * Returns a map of pairs (name, status) which contains advanced status for the current relationship.
     * @return map of status
     */
    public Map<String,Boolean> getAdvancedStatus();

    /**
     * Returns value of an advanced status.
     * @param status Status string for which advance status to be fetch.
     * @return value of advanced status
     */
    public Boolean getAdvancedStatus(String status);
    
    /**
     * Returns names of properties for which inheritance is canceled.
     * @return value of advanced status
     */
    public List<String> getCanceledProperties();
}