/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.day.cq.wcm.api.policies;


import com.day.cq.commons.LabeledResource;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;

import java.util.Calendar;

/**
 * Content Policy API.
 */
@ProviderType
public interface ContentPolicy extends Adaptable, LabeledResource {

    /**
     * Access the content policy properties.
     *
     * @return The policy properties. Must never return <code>null</code>.
     */
    public ValueMap getProperties();

    public Calendar getLastModified();

    public String getLastModifiedBy();
}
