/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api.reference;

import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.apache.sling.api.resource.Resource;

/**
 * The ReferencedResourceProvider finds references to a specific resource
 * 
 */
public interface ReferenceProvider {

    /**
     * Finds references to a specific resource
     * 
     * @param resource the resource to find references to, never null
     * @return a list of references, possibly empty but never null
     */
    List<Reference> findReferences(Resource resource);

    /**
     * Finds references to a specific resource
     *
     * @param resource the resource to find references to, never null
     * @param onlyValidReferences if set to true, will retrieve only valid references.
     * a reference is considered valid when it can be retrieved, its fields/properties respect all conditions imposed on them (i.e. regex pattern or unique property)
     * @return a list of references, possibly empty but never null
     * @throws InvalidReferenceException if any invalid references are found
     */
    default @NotNull List<Reference> findReferences(@NotNull Resource resource, boolean onlyValidReferences) throws InvalidReferenceException {
        return findReferences(resource);
    }
}
