/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.api.variants;

import java.util.List;

import org.apache.sling.api.SlingHttpServletRequest;

import com.day.cq.wcm.api.Page;

/**
 * Provides variants of a page based on cq:siteVariant nodes that link multiple sites together, that contain variants of the same content.
 * 
 * The data provided by this service is usually used to build a list of elements in HTML pages, that can be used to provide website
 * visitors with a way to switch between those site variants.
 * 
 * See also https://zerowing.corp.adobe.com/display/cq5/CQSiteVariants
 */
public interface PageVariantsProvider {
    /**
     * Returns a list of page variants to be used in the {@code <head>} section of a page in order to indicate alternate representations of
     * the same content.
     * 
     * @param page
     *            the CQ Page
     * @param request
     *            the request, in case the sent selectors must be taken into consideration; otherwise this parameter can be null
     * @return a list with the identified {@code PageVariant}s or an empty list if none was found
     */
    List<PageVariant> getVariants(Page page, SlingHttpServletRequest request);
}
