/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 * **************************************************************************/

package com.day.cq.wcm.command.api;

import org.osgi.annotation.versioning.ProviderType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * path argument interface for copy/move command
 */
@ProviderType
public interface CopyMoveCommandPathArgument extends CommandPathArgument {

    /**
     * @return destination path for the source item
     */
    @Nonnull
    String getDstPath();

    /**
     * @return reference paths of the selected item
     */
    @Nullable
    String[] getAdjustRefPaths();

    /**
     * @return publish paths referenced in the selected item
     */
    @Nullable
    String[] getPublishPaths();

}
