/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 * **************************************************************************/

package com.day.cq.wcm.command.api;

import org.osgi.annotation.versioning.ProviderType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * interface to build {@code DeleteCommandPathArgument}
 */
@ProviderType
public interface DeleteCommandPathArgumentBuilder {

    /**
     * set path of the selected item
     *
     * @param path path of the selected item
     * @return this {@code DeleteCommandPathArgumentBuilder}
     */
    @Nonnull
    DeleteCommandPathArgumentBuilder withPath(@Nonnull String path);

    /**
     * build the {@code DeleteCommandPathArgument}
     *
     * @return the built {@code DeleteCommandPathArgument}
     */
    @Nonnull
    DeleteCommandPathArgument build() throws IllegalArgumentException;

}
