/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.wcm.commons;

import java.util.Iterator;
import java.util.Stack;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class DeepResourceIterator implements Iterator<Resource> {

    final ResourceResolver resolver;
    final Stack<Iterator<Resource>> resourceTreeStack = new Stack<Iterator<Resource>>();

    Resource current;

    public DeepResourceIterator(Resource resource) {
        this.resolver = resource.getResourceResolver();
        // init stack
        resourceTreeStack.push(resolver.listChildren(resource));
        // search for first event
        current = seek();
    }

    private Resource seek() {
        while (resourceTreeStack.size() > 0) {
            Iterator<Resource> iter = resourceTreeStack.peek();
            if (iter.hasNext()) {
                Resource res = iter.next();
                // stack children to prepare for next request:
                resourceTreeStack.push(resolver.listChildren(res));
                return res;
            } else {
                resourceTreeStack.pop();
            }
        }
        return null;
    }

    public boolean hasNext() {
        return current != null;
    }

    public Resource next() {
        Resource resource = current;
        current = seek();
        return resource;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not possible on " +
                "event iterator returned by CqCalendar.getEvents()");
    }
}