/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.core.components;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

import com.day.cq.commons.JSONItem;
import com.day.cq.wcm.api.components.ComponentEditConfig;
import com.day.cq.wcm.api.components.DialogMode;
import com.day.cq.wcm.api.components.DropTarget;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.components.EditLayout;
import com.day.cq.wcm.api.components.InplaceEditingConfig;
import com.day.cq.wcm.api.components.Toolbar;
import com.day.cq.wcm.api.designer.Cell;
import com.day.cq.wcm.core.impl.components.EditConfigImpl;

/**
 * Helper class to create a edit config if not edit context is available.
 */
public class CustomEditConfig implements EditConfig {

    private EditConfigImpl base;

    public CustomEditConfig(ComponentEditConfig cfg) {
        this.base = new EditConfigImpl(cfg, null);
    }


    public void drawEditing(PrintWriter out,
                               String contentPath,
                               String resourceType,
                               String dlgPath,
                               Cell cell,
                               boolean isContainer)
            throws IOException {

        try {
            out.println("<script type=\"text/javascript\">");
            out.print("CQ.WCM.edit(");
            JSONWriter jw = new JSONWriter(out);
            jw.object();
            if (contentPath != null) {
                jw.key("path").value(contentPath);
            }
            if (dlgPath != null) {
                jw.key("dialog").value(dlgPath);
            }
            if (resourceType != null) {
                jw.key("type").value(resourceType);
            }
            if (cell != null) {
                jw.key("csp").value(cell.getSearchPath());
            }
            if (isContainer) {
                jw.key("isContainer").value(true);
            }
            jw.key("editConfig");
            this.write(jw);
            jw.endObject();
            out.println(");");
            out.println("</script>");
        } catch (JSONException e) {
            throw new IOException(e.toString());
        }
    }

    public void setLayout(EditLayout layout) {
        base.setLayout(layout);
    }

    public void setInsertBehavior(String insertBehavior) {
        base.setInsertBehavior(insertBehavior);
    }

    public void setDialogMode(DialogMode mode) {
        base.setDialogMode(mode);
    }

    public void setInplaceEditingConfig(InplaceEditingConfig inplaceEditingConfig) {
        base.setInplaceEditingConfig(inplaceEditingConfig);
    }

    public void setEmpty(boolean empty) {
        base.setEmpty(empty);
    }

    public void setEmptyText(String emptyText) {
        base.setEmptyText(emptyText);
    }

    public void setOrderable(Boolean orderable) {
        base.setOrderable(orderable);
    }

    public void setDeepCancel(Boolean deepCancel) {
        base.setDeepCancel(deepCancel);
    }

    public void setLiveRelationship(JSONItem liveRelationship) {
        base.setLiveRelationship(liveRelationship);
    }

    public boolean isDefault() {
        return base.isDefault();
    }

    public EditLayout getLayout() {
        return base.getLayout();
    }

    public Map<String, DropTarget> getDropTargets() {
        return base.getDropTargets();
    }

    public String getInsertBehavior() {
        return base.getInsertBehavior();
    }

    public Toolbar getToolbar() {
        return base.getToolbar();
    }

    public DialogMode getDialogMode() {
        return base.getDialogMode();
    }

    public InplaceEditingConfig getInplaceEditingConfig() {
        return base.getInplaceEditingConfig();
    }

    public boolean isEmpty() {
        return base.isEmpty();
    }

    public String getEmptyText() {
        return base.getEmptyText();
    }

    public Boolean isOrderable() {
        return base.isOrderable();
    }

    public Map<String, String> getFormParameters() {
        return base.getFormParameters();
    }

    public Map<String, String> getListeners() {
        return base.getListeners();
    }

    public JSONItem getLiveRelationship() {
        return base.getLiveRelationship();
    }

    public Boolean isDeepCancel() {
        return base.isDeepCancel();
    }

    public boolean isTargetingDisabled() {
        return base.isTargetingDisabled();
    }

    public void write(JSONWriter out) throws JSONException {
        base.write(out);
    }

    public Map<String, Object> getFormParameterMap() {
        return base.getFormParameterMap();
    }
}