package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.DefaultComponentTagHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Constants;

/**
 * The TagHandlerFactory that rolls out {@link DefaultComponentTagHandler} instances
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 4500, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = DefaultComponentTagHandlerFactory.TAG_PATTERN)
})
public class DefaultComponentTagHandlerFactory implements TagHandlerFactory {

    static public final String TAG_PATTERN = "<div.*(?= data-cq-component=\").*>";

    public TagHandler create() {
        return new DefaultComponentTagHandler();
    }
}
