package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.day.cq.commons.Externalizer;
import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.wcm.designimporter.api.ImporterConstants;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.TextComponentTagHandler;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.Constants;
import org.osgi.service.component.ComponentContext;

/**
 * The TagHandlerFactory that rolls out {@link TextComponentTagHandler} instances
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = TextComponentTagHandlerFactory.TAG_PATTERN),
        @Property(name = ImporterConstants.PN_RESOURCE_TYPE, value = TextComponentTagHandlerFactory.RESOURCE_TYPE_TEXT)
})
public class TextComponentTagHandlerFactory implements TagHandlerFactory {

    static protected final String RESOURCE_TYPE_TEXT = "foundation/components/text";

    /**
     * @deprecated Usage of externalizer has been removed (keeping this field for backwards compatibility)
     */
    @Reference
    @Deprecated
    Externalizer externalizer;

    static public final String TAG_PATTERN = "<(p|span|div)\\s+.*data-cq-component=\"(?i)text\".*?>";

    private String resourceType;

    public TagHandler create() {
        TextComponentTagHandler textComponentTagHandler = new TextComponentTagHandler();
        textComponentTagHandler.setResourceType(resourceType);
        return textComponentTagHandler;
    }

    /**
     * The bundle activator method. For internal use.
     * @param context
     */
    @Activate
    protected void activate(ComponentContext context) {
        resourceType = OsgiUtil.toString(context.getProperties().get(ImporterConstants.PN_RESOURCE_TYPE), RESOURCE_TYPE_TEXT);
    }

}
