package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.TitleTagHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Constants;

/**
 * The TagHandlerFactory that rolls out {@link TitleTagHandler} instances
 */
@Service
@Component(metatype = true)
@Properties({
        @Property(name = Constants.SERVICE_RANKING, intValue = 5000, propertyPrivate = false),
        @Property(name = TagHandlerFactory.PN_TAGPATTERN, value = TitleTagHandlerFactory.TAG_PATTERN)
})
public class TitleTagHandlerFactory implements TagHandlerFactory {

    static public final String TAG_PATTERN = "<title[\\s>].*>?";

    public TagHandler create() {
        return new TitleTagHandler();
    }
}
