/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.util;

import org.apache.commons.lang3.StringEscapeUtils;
import org.xml.sax.Attributes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Utility class for html tag handling
 */
public class TagUtils {

    static private Set<String> emptyTags = new HashSet<String>(Arrays.asList(new String[] { "HR", "BR", "hr", "br" }));

    /**
     * Formulates a stringified version of a start tag from the passed tag parameters. Useful for converting tag params, passed over by a SAX parser, to string.
     *
     * @param uri
     * @param localName
     * @param qName
     * @param atts
     * @return
     */
    static public String getStartTag(String uri, String localName, String qName, Attributes atts) {
        String startTag = "<" + localName.toLowerCase();

        if (!emptyTags.contains(localName)) {
            String att = "";
            for (int i = 0; i < atts.getLength(); i++) {
                att += " " + atts.getLocalName(i) + "=\"" + StringEscapeUtils.escapeHtml4(atts.getValue(i)) + "\"";
            }

            startTag += att;
            startTag += ">";
        } else {
            startTag += " />";
        }
        return startTag;
    }

    /**
     * Returns the end tag for a start tag. Usually, the end tag name is derived by inserting a / appropriately e.g. the end tag for &lt;div> is &lt;/div>
     *
     * <p>The "empty" tags like &lt;br> return an empty string
     *
     * @param startTag The name of the start tag the end tag for which is needed
     * @return The end tag corresponding to the start tag passed or empty string if an empty html tag like &lt;br> is passed
     */
    static public String getMatchingEndTag(String startTag) {
        if (startTag.matches("<.*/>")) return "";

        Matcher m = Pattern.compile("<([\\S]*).*>").matcher(startTag);
        if (m.find()) {
            return "</" + m.group(1) + ">";
        }
        return "";
    }

    public static String getClientLibIncludeTag(String clientLibCategory) {
        return "<cq:includeClientLib categories=\"" + clientLibCategory + "\" />" + "\n";
    }
}
