/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.emulator;

import org.apache.sling.api.resource.Resource;

import java.util.List;

/**
 * The <code>EmulatorService</code> provides access to {@link Emulator}s.
 *
 * @since CQ 5.4.0
 */
public interface EmulatorService {


    /**
     * Returns the emulators for the specified resource.
     *
     * @param resource The resource
     * @return The emulators
     */
    List<Emulator> getEmulators(Resource resource);

    List<EmulatorGroup> getEmulatorGroups(Resource resource);
}
