/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 * <p/>
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 * <p/>
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
/**
 * AdobePatentID="P6273-US"
 */
package com.day.cq.wcm.foundation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.cq.wcm.ui.components.container.service.AllowedComponents;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.foundation.model.impl.TemplateUtil;

/**
 * @deprecated Use {@link com.day.cq.wcm.foundation.model.AllowedComponents} instead
 */
@Deprecated
public class AllowedComponentList extends WCMUsePojo {

    private static final Logger log = LoggerFactory.getLogger(AllowedComponentList.class);

    private static final String PLACEHOLDER_COMPONENT_PATH = "wcm/foundation/components/parsys/placeholder";

    public static final String STRUCTURE_JCR_CONTENT = "/structure/jcr:content/";
    public static final String POLICIES_JCR_CONTENT = "/policies/jcr:content/";

    private List<ComponentMapping> componentMappings;

    private List<Component> sortedComponents = Collections.EMPTY_LIST;

    private class ComponentComparator implements Comparator<Component> {

        @Override
        public int compare(Component comp1, Component comp2) {
            if(comp1 != null && comp2 != null) {
                String comp1Title = comp1.getTitle();
                String comp2Title = comp2.getTitle();
                if (comp1Title == null ^ comp2Title == null) {
                    return (comp1Title == null) ? -1 : 1;
                }
                if (comp1Title == null) {
                    return 0;
                }
                return comp1Title.compareToIgnoreCase(comp2Title);
            }
            return 0;
        }
    }

    public static class ComponentMapping {

        private String path;
        private String resourceType;
        private String cssClass;

        public ComponentMapping (String path, String resourceType, String cssClass) {
            this.path = path;
            this.resourceType = resourceType;
            this.cssClass = cssClass;
        }

        public String getPath() {
            return path;
        }

        public String getResourceType() {
            return resourceType;
        }

        public String getCssClass() {
            return cssClass;
        }
    }

    @Override
    public void activate() throws Exception {
        AllowedComponents acs = getSlingScriptHelper().getService(AllowedComponents.class);
        sortedComponents = acs.getAllowedComponents(getResource());
        Collections.sort(sortedComponents, new ComponentComparator());
    }

    public String getTitle() {
        I18n i18n = new I18n(getRequest());
        String text;

        String containerName = i18n.getVar(getComponent().getTitle());

        if (!sortedComponents.isEmpty()) {
            text = containerName;
        } else {
            text = i18n.get("No allowed components for {0}", "No components have been allowed to be added to the container. Container name is 0 and is translated.", containerName);
        }

        return text;
    }

    /**
     * Is the allowed component list applicable in the current context
     *
     * @return true if component list applicable in the current context
     */
    public boolean isApplicable () {
        // Is this resource parent an authored template structure resource
        // And is it set as editable
        return TemplateUtil.isContainerStructureUnlock(this.getCurrentPage(), getResource());
    }

    private String getRelativePath(Resource resource) {
        if (resource == null) {
            return null;
        }

        String[] searchPaths = resource.getResourceResolver().getSearchPath();

        for (int i = 0; i < searchPaths.length; i++) {
            String searchPath = searchPaths[i];
            if (resource.getPath().startsWith(searchPath)) {
                String resourcePath = resource.getPath();
                return resourcePath.substring(searchPath.length(), resourcePath.length());
            }
        }

        return null;
    }

    /**
     * Returns a list of {@link ComponentMapping}s for Sightly resource instantiation usage
     *
     * @return List of component mappings
     */
    public List getComponents() {

        if (componentMappings != null) {
            return componentMappings;
        }

        componentMappings = new ArrayList<ComponentMapping>();
        String resourcePath = getResource().getPath();

        for (Component component : sortedComponents) {
            Resource componentResource = component.adaptTo(Resource.class);
            String key = resourcePath + "/" + getRelativePath(componentResource);
            getRequest().setAttribute(key, componentResource);
            componentMappings.add(new ComponentMapping(key, PLACEHOLDER_COMPONENT_PATH, "aem-AllowedComponent--component"));
        }
        return componentMappings;
    }

    /**
     * Returns the specific css class names
     *
     * @return class name
     */
    public String getCssClass () {
        String isEmpty = getComponents().isEmpty() ? " is-empty" : "";

        return isApplicable() ? "aem-AllowedComponent--list" + isEmpty : "";
    }
}
