/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.device;

import com.day.cq.wcm.mobile.api.device.capability.DeviceCapability;
import org.apache.sling.api.SlingHttpServletRequest;

import java.util.Map;

/**
 * Maps HTTP requests to Device instances
 *
 * @since CQ 5.4.0
 */
public interface DeviceMapper {

    /**
     * Returns a map of all {@link DeviceCapability}s available in the system.
     *
     * @return An unmodifiable map of capabilities.
     */
    Map<String, DeviceCapability> getCapabilities();

    /**
     * Creates a new Device instance for the supplied request.
     *
     * @param request The request to retrieve the device instance from.
     *
     * @return null if no mapping found.
     */
    Device getDeviceInstance(SlingHttpServletRequest request);

    /**
     * Returns a map of all {@link DeviceGroupFilter}s available in the system.
     *
     * @return An unmodifiable map of filters.
     */
    Map<String, DeviceGroupFilter> getFilters();
}
