/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.device.capability;

import com.day.cq.wcm.mobile.api.devicespecs.DeviceSpecsConstants;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

/**
 * Expresses javascript support of a mobile device.
 *
 * @deprecated will be removed and privatized, as capabilities are now available via {@link
 *             com.day.cq.wcm.mobile.api.device.DeviceMapper#getCapabilities()}
 */
@Component(metatype = false)
@Service
@SuppressWarnings("unused")
public class JavaScript implements DeviceCapability {

    private static final String[] KEYS = {DeviceSpecsConstants.DSPEC_AJAX_SUPPORT_JAVASCRIPT};

    /**
     * For translations:
     * i18n.get("JavaScript Support");
     * i18n.get("Indicates whether the device supports executing javascript.")
     */

    /**
     * {@inheritDoc}
     */
    public String getName() {
        return getClass().getName();
    }

    /**
     * {@inheritDoc}
     */
    public String getTitle() {
        return "JavaScript Support";
    }

    public String getDescription() {
        return "Indicates whether the device supports executing javascript.";
    }

    public String[] getKeys() {
        return KEYS;
    }
}
