/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

import java.util.Collection;

import com.day.cq.wcm.api.WCMException;

/**
 * Provides a Service to access Blueprints.
 * The Object is bound to a ResourceResolver, it my be accesses via the Managers
 * {@link BlueprintManagerFactory#getBlueprintManager(org.apache.sling.api.resource.ResourceResolver)}  Factory Method}
 * @see Blueprint
 * @see BlueprintManagerFactory
 * @since 5.4
 */
public interface BlueprintManager {

    /**
     * @return all Blueprints available int the System
     * @throws com.day.cq.wcm.api.WCMException in case of error
     */
    Collection<Blueprint> getBlueprints()throws WCMException;

    /**
     * Access the Blueprint that is stored at the given Path argument.<br>
     * If a Blueprint can be accessed, the
     * {@link com.day.cq.wcm.msm.api.Blueprint#getPath() Blueprint's path} must
     * be the same as the argument.
     *
     * @param absPath the absolute Path the blueprint should be stored at
     * @return the Blueprint for the given Path or <code>null</code> if Resource
     *         at Path is not a Blueprint
     * @throws com.day.cq.wcm.api.WCMException in case of error
     * @see com.day.cq.wcm.msm.api.Blueprint#getPath()
     */
    Blueprint getBlueprint(String absPath) throws WCMException;

    /**
     * Try to access a Blueprint for a given Resource<br>
     * A Blueprint is found if the Resource is equal or a descendant of the
     * {@link Blueprint#getSitePath()}  Blueprint's SitePath}.
     *  
     * @param path to find the Blueprint for
     * @return the Blueprint containing the path or <code>null</code> if no
     *         Blueprint is defined for the path
     * @throws com.day.cq.wcm.api.WCMException in case of error
     */
    Blueprint getContainingBlueprint(String path) throws WCMException;
}
