/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

/**
 * Constants for names used in cq MSM. Conventions:
 * <ul>
 * <li>NT_ prefix stands for "node type"
 * <li>NN_ prefix stands for "node name"
 * <li>PN_ prefix stands for "property name"
 * <li>PARAM_ prefix stands for "parameter"
 * <li>Constants all uppercase
 * <li>"replace" intercaps by underscores. eg: PN_PAGE_TITLE = "PageTitle"
 * </ul>
 */
public interface MSMNameConstants {
    static final String NT_LIVE_RELATIONSHIP = "cq:LiveRelationship";
    static final String NT_BLUEPRINT_ACTION = "cq:BlueprintAction";
    static final String NT_BLUEPRINT_SYNC_CONFIG = "cq:BlueprintSyncConfig";
    static final String NT_LIVE_SYNC = "cq:LiveSync";
    static final String NT_LIVE_SYNC_CONFIG = "cq:LiveSyncConfig";
    static final String NT_LIVE_SYNC_CANCELLED = "cq:LiveSyncCancelled";
    static final String NT_PROPERTY_LIVE_SYNC_CANCELLED = "cq:PropertyLiveSyncCancelled";
    static final String NT_LIVE_SYNC_ACTION = "cq:LiveSyncAction";

    static final String PN_LAST_ROLLEDOUT = "cq:lastRolledout";
    static final String PN_LAST_ROLLEDOUT_BY = "cq:lastRolledoutBy";
    static final String PN_SKIPPED_PAGES = "cq:skippedPages";

    static final String PN_MAIN = "cq:master";
    static final String PN_MASTER = PN_MAIN; // backwards compatible name of the constant
    static final String PN_IS_DEEP = "cq:isDeep";
    static final String PN_TRIGGER = "cq:trigger";
    static final String PN_ROLLOUT_CONFIGS = "cq:rolloutConfigs";

    static final String PN_IS_CANCELLED_FOR_CHILDREN = "cq:isCancelledForChildren";
    static final String PN_PROPERTY_INHERTIANCE_CANCELLED = "cq:propertyInheritanceCancelled";
    static final String PN_MOVE_TARGET = "cq:moveTarget";

    static final String PN_NAME = "cq:name";

    static final String PARAM_SOURCEPATH = "msm:sourcePath";
    static final String PARAM_TARGETPATH = "msm:targetPath";
    static final String PARAM_SYNCPATH = "msm:syncPath";
    static final String PARAM_LIVECOPY_PATH = "msm:liveCopyPath";
    static final String PARAM_LIVECOPY_BPPATH = "msm:liveCopyBpPath";
    static final String PARAM_LIVE_RELATIONSHIP = "msm:liveRelationship";
    static final String PARAM_TARGETS = "msm:targets";

    static final String PARAM_IS_DEEP = "msm:isDeep";
    static final String PARAM_STATUS = "msm:status";
    static final String PARAM_TRIGGER = "msm:trigger";
    static final String PARAM_COMPUTATION_TIME = "msm:computationTime";

    static final String PARAM_ACTION_CONFIG = "msm:actionConfig";

    static final String PARAM_IS_CANCELLED = "msm:isCancelled";
    static final String PARAM_IS_CANCELLED_FOR_CHILDREN = "msm:isCancelledForChildren";
    static final String PARAM_IS_EDITABLE = "msm:isEditable";
    static final String PARAM_IS_PAGE = "msm:isPage";
    static final String PARAM_IS_TARGET_EXISTING = "msm:isTargetExisting";
    static final String PARAM_IS_TARGET_DELETED = "msm:isTargetDeleted";
    static final String PARAM_IS_TARGET_MODIFIED = "msm:isTargetModified";
    static final String PARAM_IS_TARGET_CANCELLED_CHILD = "msm:isTargetCancelledChild";
    static final String PARAM_IS_TARGET_CANCELLED_PROPERTY = "msm:isTargetCancelledProperty";
    static final String PARAM_IS_TARGET_MANUALLY_CREATED = "msm:isTargetManuallyCreated";
    static final String PARAM_IS_TARGET_FROM_DIFFERENT_TREE = "msm:isTargetFromDifferentTree";
    static final String PARAM_IS_TARGET_SKIPPED = "msm:isTargetSkipped";
    static final String PARAM_IS_SOURCE_EXISTING = "msm:isSourceExisting";
    static final String PARAM_IS_SOURCE_DELETED = "msm:isSourceDeleted";
    static final String PARAM_IS_SOURCE_MODIFIED = "msm:isSourceModified";

    static final String PARAM_IS_LIVECOPY = "msm:isLiveCopy";
    static final String PARAM_IS_IN_BLUEPRINT = "msm:isInBlueprint";
    static final String PARAM_IS_SOURCE = "msm:isSource";

    static final String PARAM_IS_INHERITED_CONFIG = "msm:isInheritedConfig";
    static final String PARAM_IS_ROOT_CONFIG = "msm:isRootConfig";
    
    static final String PARAM_PROPERTY_NAME = "msm:propertyName";
    static final String PARAM_CANCELED_PROPERTIES = "msm:cancelledProperties";

}
