/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.tags;

import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

/**
 * <code>AbstractParamTag</code> is a base class for tags that modify a
 * {@link RequestURLTag}.
 */
abstract class AbstractParamTag extends TagSupport {

    private static final long serialVersionUID = -689412859703401766L;

    /**
     * The name of the parameter.
     */
    private String name;

    /**
     * The value for the parameter.
     */
    private String value;

    /**
     * Default constructor.
     */
    public AbstractParamTag() {
        super();
        init();
    }

    public final int doEndTag() throws JspException {
        try {
            RequestURLTag url = (RequestURLTag) findAncestorWithClass(this, RequestURLTag.class);
            if (url == null) {
                throw new JspTagException(getClass().getSimpleName() +
                        " must have an enclosing requestURI tag.");
            }
            applyTo(url);
            return super.doEndTag();
        } finally {
            // reset
            init();
        }
    }

    /**
     * A concrete implementation will modify the passed <code>urlTag</code> in
     * a implementation specific way.
     *
     * @param urlTag the request URL tag that will be modified.
     */
    protected abstract void applyTo(RequestURLTag urlTag);

    /**
     * Do some clean up.
     */
    public void release() {
        init();
        super.release();
    }

    //--------------------------------< properties >----------------------------

    public String getName() {
        return name;
    }

    public void setName(String name) throws ELException {
        this.name = evaluate(name, String.class);
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) throws ELException {
        this.value = evaluate(value, String.class);
    }

    //-----------------------------< internal >---------------------------------

    private void init() {
        name = null;
        value = null;
    }

    /**
     * Evaluates the given expression.
     *
     * @param expression the expression.
     * @param clazz the expected type of the return value.
     * @return the evaluated expression.
     * @throws ELException if an error occurs while evaluating the expression.
     */
    @SuppressWarnings({"unchecked"})
    private <T> T evaluate(String expression, Class<T> clazz)
            throws ELException {
        return (T) pageContext.getExpressionEvaluator().evaluate(
                expression, clazz, pageContext.getVariableResolver(), null);
    }
}
